clear
close all
clc

prompt = 'write turbine name: ';

name = input(prompt,'s');

load(strcat('Tavg',name,'.mat'));

prompt = 'write nominal windspeed: ';

Vnom = input(prompt);

Tu = T(:,Vnom,1);
Tu = squeeze(Tu);
Pv = Tu.*w';
Pnom  = max(Tu.*w');
om = w;
Vwind = 1:1:25;
% pthv = (0:3:18)';
diff2 = zeros(13,1);
diff3 = zeros(25,1);
% diff2 = zeros(7,1);
pv = zeros(25,1);
wnom = w(find(Pnom==Pv));
jjj = zeros(25,1);
wopt = jjj;
Popt = jjj;
mi = jjj;
for ii = 1:25
    Tau = T(:,ii,:);
    Tau = squeeze(Tau);
    PP = (Tau'.*om)';
    Pw = interp1(om,PP,wnom);
    ang = interp1(Pw,pitch,Pnom);
    if ii<Vnom+1
        ang = 0;
    end
    pv(ii) = ang;
    a = find(wopt(ii) == om);
end
for ii = 1:25
    Tau = T(:,ii,:);
    Tau = squeeze(Tau);
    Pavg = (Tau'.*om)';
    xx = pv(ii)*180/pi;
    if ii<Vnom+1
        mm = max(Pavg);
        Popt(ii) = max(mm);
    else
        Popt(ii) = interp2(pitch*180/pi,w,Pavg,xx,wnom);
    end
end
%% calcolo dP/dp
deriv = zeros(25,1);
for ii = 1:25
    Tau = T(:,ii,:);
    Tau = squeeze(Tau);
    PP = (Tau'.*om)';
%     PP = Pavg.P(:,ii,:);
%     PP = squeeze(PP);
    PV = interp1(w,PP,wnom); % P @wnom
    P0 = interp1(pitch,PV,pv(ii)-1/180*pi); % P @wnom
    P1 = interp1(pitch,PV,pv(ii)+1/180*pi);
    dP = P1-P0;
    dp = 2;
    deriv(ii) = dP/dp;
%     if isnan(deriv(ii))
%         deriv(ii) = 0;
%     end
end
% test interpolazione
figure(2)
plot(pv*180/pi,deriv,'kd-')
xlabel('pitch (deg)')
ylabel('dP/dpitch (W/deg)')
title('dP/dpitch at nominal rotational speed')
grid on
box on

figure(3)
plot(Vwind,wopt)
xlabel('Windspeed(m/s)')
ylabel('\gamma pitch angle(deg)')
title('\omega = \omega(V) at approximated pitch')
grid on
box on

figure(4)
plot(Vwind,pv*180/pi,'kd-')
xlabel('Windspeed(m/s)')
ylabel('Pitch angle (deg)')
title('Pitch = Pitch(V)')
grid on
box on

pitchstr.p = pv;
pitchstr.V = Vwind;